/*  
 * Copyright (c) 2008, Sun Microsystems, Inc.
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Sun Microsystems nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *  Note:  In order to comply with the binary form redistribution 
 *         requirement in the above license, the licensee may include 
 *         a URL reference to a copy of the required copyright notice, 
 *         the list of conditions and the disclaimer in a human readable 
 *         file with the binary form of the code that is subject to the
 *         above license.  For example, such file could be put on a 
 *         Blu-ray disc containing the binary form of the code or could 
 *         be put in a JAR file that is broadcast via a digital television 
 *         broadcast medium.  In any event, you must include in any end 
 *         user licenses governing any code that includes the code subject 
 *         to the above license (in source and/or binary form) a disclaimer 
 *         that is at least as protective of Sun as the disclaimers in the 
 *         above license.
 * 
 *         A copy of the required copyright notice, the list of conditions and
 *         the disclaimer will be maintained at 
 *         https://hdcookbook.dev.java.net/misc/license.html .
 *         Thus, licensees may comply with the binary form redistribution
 *         requirement with a text file that contains the following text:
 * 
 *             A copy of the license(s) governing this code is located
 *             at https://hdcookbook.dev.java.net/misc/license.html
 */


package net.java.bd.tools.playlist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * BD-ROM Part 3-1 5.3.4.5.1 STN_table
 * STN == STream Number
 */
public class STNTable {
    
    private PrimaryVideoStreamEntry[] primaryVideoStreams;
    private PrimaryAudioStreamEntry[] primaryAudioStreams;
    private PGTextSTStreamEntry[] pgTextSTStreams;  
    private IGStreamEntry[] igStreams;
    private SecondaryVideoStreamEntry[] secondaryVideoStreams;
    private SecondaryAudioStreamEntry[] secondaryAudioStreams;
    private Integer pipPGTextSTStreamEntriesPlus;
    
    public void readObject(DataInputStream din) throws IOException {
        int length = din.readUnsignedShort();
        byte[] data = new byte[length];
        din.readFully(data);
        readObject0(new DataInputStream(new ByteArrayInputStream(data)));
    }
    
    
    public void readObject0(DataInputStream din) throws IOException {
        
        //int length = din.readUnsignedShort();
        din.skipBytes(2);
        int primaryVideoStreamLength   = din.readByte();
        int primaryAudioStreamLength   = din.readByte();
        int pgTextStStreamLength       = din.readByte();
        int igStreamLength             = din.readByte();
        int secondaryAudioStreamLength = din.readByte();
        int secondaryVideoStreamLength = din.readByte();
        int pipPGTextStStreamLength    = din.readByte();
        din.skipBytes(5);
        
        if (primaryVideoStreamLength > 0) {
            setPrimaryVideoStreams(new PrimaryVideoStreamEntry[primaryVideoStreamLength]);
            for (int i = 0; i < primaryVideoStreamLength; i++) {
                getPrimaryVideoStreams()[i] = new PrimaryVideoStreamEntry(i);
                getPrimaryVideoStreams()[i].readObject(din);
            }
        }
        if (primaryAudioStreamLength > 0)  {
            setPrimaryAudioStreams(new PrimaryAudioStreamEntry[primaryAudioStreamLength]);
            for (int i = 0; i < primaryAudioStreamLength; i++) {
                getPrimaryAudioStreams()[i] = new PrimaryAudioStreamEntry(i);
                getPrimaryAudioStreams()[i].readObject(din);
            }
        }    
        if (pgTextStStreamLength > 0 ||
            pipPGTextStStreamLength > 0) {
            
            setPipPGTextSTStreamEntriesPlus(pipPGTextStStreamLength);
            int allPGTextStStreamLength = pgTextStStreamLength + pipPGTextStStreamLength;            
            setPGTextSTStreams(new PGTextSTStreamEntry[allPGTextStStreamLength]);
            
            for (int i = 0; i < allPGTextStStreamLength; i++) {
                getPGTextSTStreams()[i] = new PGTextSTStreamEntry(i);
                getPGTextSTStreams()[i].readObject(din);
            }            
        }
        if (igStreamLength > 0) {
            setIGStreams(new IGStreamEntry[igStreamLength]);
            for (int i = 0; i < igStreamLength; i++) {
                getIGStreams()[i] = new IGStreamEntry(i);
                getIGStreams()[i].readObject(din);
            }            
        } 
        if (secondaryAudioStreamLength > 0) {
            setSecondaryAudioStreams(new SecondaryAudioStreamEntry[secondaryAudioStreamLength]);
            for (int i = 0; i < secondaryAudioStreamLength; i++) {
                getSecondaryAudioStreams()[i] = new SecondaryAudioStreamEntry(i);
                getSecondaryAudioStreams()[i].readObject(din);
            }            
        }         
        if (secondaryVideoStreamLength > 0) {
            setSecondaryVideoStreams(new SecondaryVideoStreamEntry[secondaryVideoStreamLength]);
            for (int i = 0; i < secondaryVideoStreamLength; i++) {
                getSecondaryVideoStreams()[i] = new SecondaryVideoStreamEntry(i);
                getSecondaryVideoStreams()[i].readObject(din);
            }            
        }           
    }

    public PrimaryVideoStreamEntry[] getPrimaryVideoStreams() {
        return primaryVideoStreams;
    }

    public void setPrimaryVideoStreams(PrimaryVideoStreamEntry[] primaryVideoStreams) {
        this.primaryVideoStreams = primaryVideoStreams;
    }

    public PrimaryAudioStreamEntry[] getPrimaryAudioStreams() {
        return primaryAudioStreams;
    }

    public void setPrimaryAudioStreams(PrimaryAudioStreamEntry[] primaryAudioStreams) {
        this.primaryAudioStreams = primaryAudioStreams;
    }

    public PGTextSTStreamEntry[] getPGTextSTStreams() {
        return pgTextSTStreams;
    }

    public void setPGTextSTStreams(PGTextSTStreamEntry[] pgTextStStreams) {
        this.pgTextSTStreams = pgTextStStreams;
    }
    
    public IGStreamEntry[] getIGStreams() {
        return igStreams;
    }

    public void setIGStreams(IGStreamEntry[] igStreams) {
        this.igStreams = igStreams;
    }

    public SecondaryVideoStreamEntry[] getSecondaryVideoStreams() {
        return secondaryVideoStreams;
    }

    public void setSecondaryVideoStreams(SecondaryVideoStreamEntry[] secondaryVideoStreams) {
        this.secondaryVideoStreams = secondaryVideoStreams;
    }
    
    public SecondaryAudioStreamEntry[] getSecondaryAudioStreams() {
        return secondaryAudioStreams;
    }

    public void setSecondaryAudioStreams(SecondaryAudioStreamEntry[] secondaryAudioStreams) {
        this.secondaryAudioStreams = secondaryAudioStreams;
    }

    public Integer getPipPGTextSTStreamEntriesPlus() {
        return pipPGTextSTStreamEntriesPlus;
    }

    public void setPipPGTextSTStreamEntriesPlus(Integer pipPGTextSTStreamEntriesPlus) {
        this.pipPGTextSTStreamEntriesPlus = pipPGTextSTStreamEntriesPlus;
    }
}
