/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class JarDir extends FsDir {

    protected ZipFile zipFile = null;

    protected abstract String getRelativePath();

    @Override
    protected boolean deleteObject(FsObject obj) {
        return false;
    }

    @Override
    protected FsDir createDirectoryObject(String name) {
        return null;
    }

    @Override
    protected FsFile createFileObject(String name) {
        return null;
    }

    @Override
    protected void populateEntries() {
        String relativePath = getRelativePath();

        callPopulateAttributes();

        Enumeration<? extends ZipEntry> zenum = zipFile.entries();
        while (zenum.hasMoreElements()) {
            ZipEntry entry = zenum.nextElement();
            String name = entry.getName();
            if (relativePath.length() != 0) {
                if (name.startsWith(relativePath) == false)
                    continue;
            }
            String tail = name.substring(relativePath.length());
            int ns = tail.indexOf('/');

            StringBuilder childPath = new StringBuilder(path.length() + tail.length() + 1);
            childPath.append(path);
            childPath.append('/');

            if (ns < 0) {
                childPath.append(tail);
                JarFile fileObj = new JarFile(zipFile, entry, childPath.toString());
                entries.put(tail, fileObj);
            } else {
                String dirName = tail.substring(0, ns);
                if (entries.get(dirName) == null) {
                    childPath.append(dirName);

                    StringBuilder nativePath = new StringBuilder(relativePath.length() + dirName.length() + 1);
                    nativePath.append(relativePath);
                    nativePath.append(dirName);
                    nativePath.append('/');

                    JarDir dirObj = new JarInnerDir(zipFile, entry, childPath.toString(), nativePath.toString());
                    entries.put(dirName, dirObj);
                }
            }
        }
    }

}
