/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.awt;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.HashMap;

import impl.java.io.BluesFileSystem;

public class FontMetricsProxy extends jail.java.awt.FontMetrics {

    private static  HashMap<jail.java.awt.Font,java.awt.Font>   fontMap = new HashMap<jail.java.awt.Font,java.awt.Font>();

    private transient java.awt.FontMetrics peer;

    protected FontMetricsProxy(jail.java.awt.Font font) {
        super(font);
        peer = createNative(fontFromJail(font));
    }

    public int getLeading() {
        return peer.getLeading();
    }

    public int getAscent() {
        return peer.getAscent();
    }

    public int getDescent() {
        return peer.getDescent();
    }

    public int getHeight() {
        return peer.getHeight();
    }

    public int getMaxAscent() {
        return peer.getMaxAscent();
    }

    public int getMaxDescent() {
        return peer.getMaxDescent();
    }

    public int getMaxAdvance() {
        return peer.getMaxAdvance();
    }

    public int charWidth(int ch) {
        return peer.charWidth(ch);
    }

    public int charWidth(char ch) {
        return peer.charWidth(ch);
    }

    public int stringWidth(String str) {
        return peer.stringWidth(str);
    }

    public int charsWidth(char data[], int off, int len) {
        return peer.charsWidth(data,off,len);
    }

    public int bytesWidth(byte data[], int off, int len) {
        return peer.bytesWidth(data,off,len);
    }

    public int[] getWidths() {
        return peer.getWidths();
    }

    private java.awt.FontMetrics createNative(java.awt.Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static FontMetricsProxy getFontMetrics(jail.java.awt.Font font) {
        return new FontMetricsProxy(font);
    }

    private static final String[] systemFontList = new String[] {
            "serif","sansserif","monospaced","dialog","dialoginput", "default"};


    public static synchronized String[] getFontList() {
        return systemFontList;
    }

    private static synchronized java.awt.Font fontFromJail(jail.java.awt.Font font) {
        java.awt.Font nativeFont = fontMap.get(font);
        if (nativeFont==null) {
            nativeFont = new java.awt.Font(font.getName(),font.getStyle(),font.getSize());
            if (nativeFont!=null) {
                addNativeFont(nativeFont);
            }
        }
        return nativeFont;
    }

    private static synchronized void addNativeFont(java.awt.Font font) {
        jail.java.awt.Font jailFont = new jail.java.awt.Font(font.getName(),font.getStyle(),font.getSize());
        java.awt.Font haveFont = fontMap.get(jailFont);
        if (haveFont==null) {
            fontMap.put(jailFont, font);
        }
    }

    private static java.awt.Font createTrueTypeFont(java.io.File fontFile) throws IOException, java.awt.FontFormatException {
        return java.awt.Font.createFont(java.awt.Font.TRUETYPE_FONT, fontFile);
    }

    public static jail.java.awt.Font createTrueTypeFont(jail.java.io.File fontFile,int style, float size) throws IOException, java.awt.FontFormatException {
        String localPath = BluesFileSystem.getLocalPath(fontFile.getAbsolutePath());
        java.awt.Font font =  createTrueTypeFont(new java.io.File(localPath)).deriveFont(style,size);
        addNativeFont(font);
        return new jail.java.awt.Font(font.getName(),font.getStyle(),font.getSize());
    }

    public static jail.java.awt.Font createTrueTypeFont(jail.java.net.URL fontURL,float size) throws IOException, java.awt.FontFormatException {
        String localPath = BluesFileSystem.getLocalPath(fontURL.openStream(), "font.ttf");
        java.awt.Font font = createTrueTypeFont(new java.io.File(localPath)).deriveFont(size);
        addNativeFont(font);
        return new jail.java.awt.Font(font.getName(),font.getStyle(),font.getSize());
    }

    public static synchronized jail.java.awt.Font deriveFont(jail.java.awt.Font font,int style, float size) {
        java.awt.Font nativeFont = fontFromJail(font).deriveFont(style,size);
        jail.java.awt.Font fontJail = new jail.java.awt.Font(nativeFont.getName(),nativeFont.getStyle(),nativeFont.getSize());
        if (fontMap.get(fontJail)==null) {
            addNativeFont(nativeFont);
        }
        return fontJail;
    }

}
