/*
 * This file is part of libbluray
 * Copyright (C) 2009-2017  Petri Hintukainen <phintuka@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package hdmv;

import hdmv.INSN.HDMV_INSN;
import hdmv.INSN.MOBJ_CMD;

public class MOBJPrint {

    static final String NULL = null; 

static final String[] str_psr_info = new String[] {
    "/*     PSR0:  Interactive graphics stream number */",
    "/*     PSR1:  Primary audio stream number */",
    "/*     PSR2:  PG TextST stream number and PiP PG stream number */",
    "/*     PSR3:  Angle number */",
    "/*     PSR4:  Title number */",
    "/*     PSR5:  Chapter number */",
    "/*     PSR6:  PlayList ID */",
    "/*     PSR7:  PlayItem ID */",
    "/*     PSR8:  Presentation time */",
    "/*     PSR9:  Navigation timer */",
    "/*     PSR10: Selected button ID */",
    "/*     PSR11: Page ID */",
    "/*     PSR12: User style number */",
    "/* RO: PSR13: User age */",
    "/*     PSR14: Secondary audio stream number and secondary video stream number */",
    "/* RO: PSR15: player capability for audio */",
    "/* RO: PSR16: Language code for audio */",
    "/* RO: PSR17: Language code for PG and Text subtitles */",
    "/* RO: PSR18: Menu description language code */",
    "/* RO: PSR19: Country code */",
    "/* RO: PSR20: Region code */ /* 1 - A, 2 - B, 4 - C */",
    "/* RO: PSR21: Output Mode Preference */ /* 0 - 2D, 1 - 3D */",
    "/*     PSR22: Stereoscopic status */ /* 2D / 3D */ ",
    "/* RO: PSR23: display capablity */",
    "/* RO: PSR24: 3D capability */",
    "/* RO: PSR25: UHD capability */",
    "/* RO: PSR26: UHD display capability */",
    "/* RO: PSR27: HDR preference */",
    "/* RO: PSR28: SDR conversion preference */",
    "/* RO: PSR29: player capability for video */",
    "/* RO: PSR30: player capability for text subtitle */",
    "/* RO: PSR31: Player profile and version */",
    "/*     PSR32 */",
    "/*     PSR33 */",
    "/*     PSR34 */",
    "/*     PSR35 */",
    "/*     PSR36: backup PSR4 */",
    "/*     PSR37: backup PSR5 */",
    "/*     PSR38: backup PSR6 */",
    "/*     PSR39: backup PSR7 */",
    "/*     PSR40: backup PSR8 */",
    "/*     PSR41: */",
    "/*     PSR42: backup PSR10 */",
    "/*     PSR43: backup PSR11 */",
    "/*     PSR44: backup PSR12 */",
    "/*     PSR45: */",
    "/*     PSR46: */",
    "/*     PSR47: */",
    "/* RO: PSR48: Characteristic text caps */",
    "/* RO: PSR49: Characteristic text caps */",
    "/* RO: PSR50: Characteristic text caps */",
    "/* RO: PSR51: Characteristic text caps */",
    "/* RO: PSR52: Characteristic text caps */",
    "/* RO: PSR53: Characteristic text caps */",
    "/* RO: PSR54: Characteristic text caps */",
    "/* RO: PSR55: Characteristic text caps */",
    "/* RO: PSR56: Characteristic text caps */",
    "/* RO: PSR57: Characteristic text caps */",
    "/* RO: PSR58: Characteristic text caps */",
    "/* RO: PSR59: Characteristic text caps */",
    "/* RO: PSR60: Characteristic text caps */",
    "/* RO: PSR61: Characteristic text caps */",
    /* PSR62 */ NULL,
    /* PSR63 */ NULL,
    /* PSR64 */ NULL,
    /* PSR65 */ NULL,
    /* PSR66 */ NULL,
    /* PSR67 */ NULL,
    /* PSR68 */ NULL,
    /* PSR69 */ NULL,
    /* PSR70 */ NULL,
    /* PSR71 */ NULL,
    /* PSR72 */ NULL,
    /* PSR73 */ NULL,
    /* PSR74 */ NULL,
    /* PSR75 */ NULL,
    /* PSR76 */ NULL,
    /* PSR77 */ NULL,
    /* PSR78 */ NULL,
    /* PSR79 */ NULL,
    /* PSR80 */ NULL,
    /* PSR81 */ NULL,
    /* PSR82 */ NULL,
    /* PSR83 */ NULL,
    /* PSR84 */ NULL,
    /* PSR85 */ NULL,
    /* PSR86 */ NULL,
    /* PSR87 */ NULL,
    /* PSR88 */ NULL,
    /* PSR89 */ NULL,
    /* PSR90 */ NULL,
    /* PSR91 */ NULL,
    /* PSR92 */ NULL,
    /* PSR93 */ NULL,
    /* PSR94 */ NULL,
    /* PSR95 */ NULL,
    /* PSR96 */ NULL,
    /* PSR97 */ NULL,
    /* PSR98 */ NULL,
    /* PSR99 */ NULL,
    /* PSR100 */ NULL,
    /* PSR101 */ NULL,
    "/*     PSR102: BD+ receive */",
    "/*     PSR103: BD+ send */",
    "/*     PSR104: BD+ shared */",
    /* PSR105 */ NULL,
    /* PSR106 */ NULL,
    /* PSR107 */ NULL,
    /* PSR108 */ NULL,
    /* PSR109 */ NULL,
    /* PSR110 */ NULL,
    /* PSR111 */ NULL,
    /* PSR112 */ NULL,
    /* PSR113 */ NULL,
    /* PSR114 */ NULL,
    /* PSR115 */ NULL,
    /* PSR116 */ NULL,
    /* PSR117 */ NULL,
    /* PSR118 */ NULL,
    /* PSR119 */ NULL,
    /* PSR120 */ NULL,
    /* PSR121 */ NULL,
    /* PSR122 */ NULL,
    /* PSR123 */ NULL,
    /* PSR124 */ NULL,
    /* PSR125 */ NULL,
    /* PSR126 */ NULL,
    /* PSR127 */ NULL,
};

static final String[] str_insn_opt_set = new String[] {
    NULL,
    "move",
    "swap",
    "add",
    "sub",
    "mul",
    "div",
    "mod",
    "rnd",
    "and",
    "or",
    "xor",
    "bset",
    "bclr",
    "shl",
    "shr",
};

static final String[] str_insn_opt_setsys = new String[] {
    NULL,
    "SET_STREAM",
    "SET_NV_TIMER",
    "SET_BUTTON_PAGE",
    "ENABLE_BUTTON",
    "DISABLE_BUTTON",
    "SET_SEC_STREAM",
    "POPUP_OFF",
    "STILL_ON",
    "STILL_OFF",
    "SET_OUTPUT_MODE",
    "SET_STREAM_SS",
    NULL,
    NULL,
    NULL,
    NULL,
    "[SETSYSTEM_0x10]",
};

static final String[] str_insn_opt_cmp = new String[] {
    NULL,
    "bc",
    "eq",
    "ne",
    "ge",
    "gt",
    "le",
    "lt",
};

static final String[] str_insn_opt_goto = new String[] {
    "nop",
    "goto",
    "break",
};

static final String[] str_insn_opt_jump = new String[] {
    "JUMP_OBJECT",
    "JUMP_TITLE",
    "CALL_OBJECT",
    "CALL_TITLE",
    "RESUME"
};

static final String[] str_insn_opt_play = new String[] {
    "PLAY_PL",
    "PLAY_PL_PI",
    "PLAY_PL_MK",
    "TERMINATE_PL",
    "LINK_PI",
    "LINK_MK"
};

static String psr_info(int n) {
    return (n<str_psr_info.length) ? str_psr_info[n] : null; 
}

static String insn_opt_goto(int n) {
    return (n<str_insn_opt_goto.length) ? str_insn_opt_goto[n] : null; 
}

static String insn_opt_jump(int n) {
    return (n<str_insn_opt_jump.length) ? str_insn_opt_jump[n] : null; 
}

static String insn_opt_play(int n) {
    return (n<str_insn_opt_play.length) ? str_insn_opt_play[n] : null; 
}

static String insn_opt_cmp(int n) {
    return (n<str_insn_opt_cmp.length) ? str_insn_opt_cmp[n] : null; 
}

static String insn_opt_set(int n) {
    return (n<str_insn_opt_set.length) ? str_insn_opt_set[n] : null; 
}

static String insn_opt_setsys(int n) {
    return (n<str_insn_opt_setsys.length) ? str_insn_opt_setsys[n] : null; 
}

static void sprintf(StringBuilder buf,String str)
{
    buf.append(str);
}
static void sprintf(StringBuilder buf,String fmt,int v0)
{
    buf.append(String.format(fmt,v0));
}
static void sprintf(StringBuilder buf,String fmt,String v0)
{
    buf.append(String.format(fmt,v0));
}
static void sprintf(StringBuilder buf,String fmt,int v0,int v1,int v2)
{
    buf.append(String.format(fmt,v0,v1,v2));
}

static int _sprint_operand(StringBuilder buf, boolean imm, int op)
{
    int psr = -1;

    if (!imm) {
        if (0!=(op & 0x80000000)) {
            sprintf(buf, "PSR%-3d", op & 0x7f);
            psr = op & 0x7f;
        } else {
            sprintf(buf, "r%-5d", op & 0xfff);
        }
    } else {
        if (op < 99999)
            sprintf(buf, "%-6d", op);
        else
            sprintf(buf, "0x%-4x", op);
    }

    return psr;
}

static void _sprint_operands(StringBuilder buf, MOBJ_CMD cmd)
{
    HDMV_INSN insn  = cmd.insn;
    int psr1 = -1, psr2 = -1;

    if (insn.op_cnt > 0) {
        psr1 = _sprint_operand(buf, insn.imm_op1, cmd.dst);

        if (insn.op_cnt > 1) {
            sprintf(buf, ",\t");
            psr2 = _sprint_operand(buf, insn.imm_op2, cmd.src);
        } else {
            sprintf(buf, " \t      ");
        }
    } else {
        sprintf(buf, "       \t      ");
    }

    if (psr1 >= 0 && psr1 < 128 && (null!=psr_info(psr1)))
        sprintf(buf, " %s", psr_info(psr1));
    if (psr2 >= 0 && psr2 < 128 && psr2 != psr1 && (null!=psr_info(psr2)))
        sprintf(buf, " %s", psr_info(psr2));

}

static void _sprint_operands_hex(StringBuilder buf, MOBJ_CMD cmd)
{
    HDMV_INSN insn  = cmd.insn;

    if (insn.op_cnt > 0) {
        sprintf(buf, "0x%-4x", cmd.dst);
    }
    if (insn.op_cnt > 1) {
        sprintf(buf,  ",\t0x%-4x", cmd.src);
    }
}

public static void mobj_sprint_cmd(StringBuilder buf, MOBJ_CMD cmd)
{
    HDMV_INSN insn = cmd.insn;

    sprintf(buf, "%08x %08x,%08x  ", insn.opcode, cmd.dst, cmd.src);

    switch(insn.grp) {
        case INSN.GROUP_BRANCH:
            switch(insn.sub_grp) {
                case INSN.BRANCH_GOTO:
                    if (null!=insn_opt_goto(insn.branch_opt)) {
                        sprintf(buf, "%-10s ", insn_opt_goto(insn.branch_opt));
                        _sprint_operands(buf, cmd);
                    } else {
                      sprintf(buf, "[unknown BRANCH/GOTO option in opcode 0x%08x] ", insn.opcode);
                    }
                    break;
            case INSN.BRANCH_JUMP:
                if (null!=insn_opt_jump(insn.branch_opt)) {
                    sprintf(buf, "%-10s ", insn_opt_jump(insn.branch_opt));
                    _sprint_operands(buf, cmd);
                } else {
                    sprintf(buf, "[unknown BRANCH/JUMP option in opcode 0x%08x] ", insn.opcode);
                }
                break;
            case INSN.BRANCH_PLAY:
                if (null!=insn_opt_play(insn.branch_opt)) {
                    sprintf(buf, "%-10s ", insn_opt_play(insn.branch_opt));
                    _sprint_operands(buf, cmd);
                } else {
                    sprintf(buf, "[unknown BRANCH/PLAY option in opcode 0x%08x] ", insn.opcode);
                }
                break;
            default:
                sprintf(buf, "[unknown BRANCH subgroup in opcode 0x%08x] ", insn.opcode);
                break;
            }
            break;

        case INSN.GROUP_CMP:
            if (null!=insn_opt_cmp(insn.cmp_opt)) {
                sprintf(buf, "%-10s ", insn_opt_cmp(insn.cmp_opt));
                _sprint_operands(buf, cmd);
            } else {
                sprintf(buf, "[unknown COMPARE option in opcode 0x%08x] ", insn.opcode);
            }
            break;

        case INSN.GROUP_SET:
            switch (insn.sub_grp) {
                case INSN.SET_SET:
                    if (null!=insn_opt_set(insn.set_opt)) {
                        sprintf(buf, "%-10s ", insn_opt_set(insn.set_opt));
                        _sprint_operands(buf, cmd);
                    } else {
                        sprintf(buf, "[unknown SET option in opcode 0x%08x] ", insn.opcode);
                    }
                    break;
            case INSN.SET_SETSYSTEM:
                if (null!=insn_opt_setsys(insn.set_opt)) {

                    sprintf(buf, "%-10s ", insn_opt_setsys(insn.set_opt));
                    if (insn.set_opt == INSN.SET_STREAM ||
                        insn.set_opt == INSN.SET_SEC_STREAM ||
                        insn.set_opt == INSN.SET_BUTTON_PAGE) {
                        _sprint_operands_hex(buf, cmd);
                    } else {
                        _sprint_operands(buf, cmd);
                    }
                } else {
                    sprintf(buf, "[unknown SETSYSTEM option in opcode 0x%08x] ", insn.opcode);
                }
                break;
            default:
                sprintf(buf, "[unknown SET subgroup in opcode 0x%08x] ", insn.opcode);
                break;
            }
            break;

        default:
            sprintf(buf, "[unknown group in opcode 0x%08x] ", insn.opcode);
            break;
    }
}

}